<?php
use CRM_BatchEntry_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Contribution_Batch_Entry',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Contribution_Batch_Entry',
        'label' => E::ts('Contribution Batch'),
        'api_entity' => 'Contribution',
        'api_params' => [
          'version' => 4,
          'select' => [
            'contact_id',
            'total_amount',
            'fee_amount',
            'net_amount',
            'contribution_status_id:label',
            'financial_type_id:label',
            'receive_date',
            'source',
            'payment_instrument_id:label',
            'check_number',
            'invoice_number',
            'Contribution_ContributionSoft_contribution_id_01.soft_credit_type_id:label',
            'Contribution_ContributionSoft_contribution_id_01.contact_id',
            'Contribution_ContributionSoft_contribution_id_01.amount',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => [],
          'join' => [
            [
              'ContributionSoft AS Contribution_ContributionSoft_contribution_id_01',
              'LEFT',
              [
                'id',
                '=',
                'Contribution_ContributionSoft_contribution_id_01.contribution_id',
              ],
            ],
          ],
          'having' => [],
        ],
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Contribution_Batch_Entry_SearchDisplay_Contribution_Batch',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Contribution_Batch',
        'label' => E::ts('Contribution Batch'),
        'saved_search_id.name' => 'Contribution_Batch_Entry',
        'type' => 'batch',
        'settings' => [
          'classes' => [
            'table',
            'table-striped',
            'table-bordered',
            'crm-sticky-header',
          ],
          'limit' => 15,
          'pager' => [
            'hide_single' => TRUE,
          ],
          'columns' => [
            [
              'type' => 'field',
              'key' => 'contact_id',
              'label' => E::ts('Contact'),
              'required' => TRUE,
              'spec' => [
                'name' => 'contact_id',
                'data_type' => 'Integer',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'contact_id',
                'original_field_entity' => 'Contribution',
                'input_type' => 'EntityRef',
                'entity_reference' => [
                  'entity' => 'Contact',
                  'key' => 'id',
                  'on_delete' => 'CASCADE',
                ],
                'required' => TRUE,
                'nullable' => FALSE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'total_amount',
              'label' => E::ts('Total Amount'),
              'tally' => [
                'fn' => 'SUM',
                'target' => TRUE,
              ],
              'required' => TRUE,
              'spec' => [
                'name' => 'total_amount',
                'data_type' => 'Money',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'total_amount',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Text',
                'entity_reference' => NULL,
                'required' => TRUE,
                'nullable' => FALSE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'fee_amount',
              'label' => E::ts('Fee Amount'),
              'tally' => [
                'fn' => 'SUM',
              ],
              'spec' => [
                'name' => 'fee_amount',
                'data_type' => 'Money',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'fee_amount',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Text',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'net_amount',
              'label' => E::ts('Net Amount'),
              'tally' => [
                'fn' => 'SUM',
              ],
              'spec' => [
                'name' => 'net_amount',
                'data_type' => 'Money',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'net_amount',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Text',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'contribution_status_id:label',
              'label' => E::ts('Contribution Status'),
              'default' => '1',
              'spec' => [
                'name' => 'contribution_status_id',
                'data_type' => 'Integer',
                'suffixes' => [
                  'id',
                  'label',
                ],
                'options' => TRUE,
                'serialize' => NULL,
                'original_field_name' => 'contribution_status_id',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Select',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'financial_type_id:label',
              'label' => E::ts('Financial Type'),
              'required' => TRUE,
              'spec' => [
                'name' => 'financial_type_id',
                'data_type' => 'Integer',
                'suffixes' => [
                  'id',
                  'label',
                ],
                'options' => TRUE,
                'serialize' => NULL,
                'original_field_name' => 'financial_type_id',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Select',
                'entity_reference' => [
                  'entity' => 'FinancialType',
                  'key' => 'id',
                ],
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'receive_date',
              'label' => E::ts('Contribution Date'),
              'spec' => [
                'name' => 'receive_date',
                'data_type' => 'Timestamp',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'receive_date',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Select Date',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'source',
              'label' => E::ts('Contribution Source'),
              'spec' => [
                'name' => 'source',
                'data_type' => 'String',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'source',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Text',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'payment_instrument_id:label',
              'label' => E::ts('Payment Method'),
              'spec' => [
                'name' => 'payment_instrument_id',
                'data_type' => 'Integer',
                'suffixes' => [
                  'id',
                  'label',
                ],
                'options' => TRUE,
                'serialize' => NULL,
                'original_field_name' => 'payment_instrument_id',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Select',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'check_number',
              'label' => E::ts('Check Number'),
              'spec' => [
                'name' => 'check_number',
                'data_type' => 'String',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'check_number',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Text',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'invoice_number',
              'label' => E::ts('Invoice Number'),
              'spec' => [
                'name' => 'invoice_number',
                'data_type' => 'String',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'invoice_number',
                'original_field_entity' => 'Contribution',
                'input_type' => 'Text',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'Contribution_ContributionSoft_contribution_id_01.soft_credit_type_id:label',
              'label' => E::ts('Soft Credit Type'),
              'spec' => [
                'name' => 'Contribution_ContributionSoft_contribution16b3265579af7863',
                'data_type' => 'Integer',
                'suffixes' => [
                  'id',
                  'label',
                ],
                'options' => TRUE,
                'serialize' => NULL,
                'original_field_name' => 'soft_credit_type_id',
                'original_field_entity' => 'ContributionSoft',
                'input_type' => 'Select',
                'entity_reference' => NULL,
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
            [
              'type' => 'field',
              'key' => 'Contribution_ContributionSoft_contribution_id_01.contact_id',
              'label' => E::ts('Soft Credit Contact'),
              'spec' => [
                'name' => 'Contribution_ContributionSoft_contribution2fcfe8c2b6254fe7',
                'data_type' => 'Integer',
                'suffixes' => NULL,
                'options' => FALSE,
                'serialize' => NULL,
                'original_field_name' => 'contact_id',
                'original_field_entity' => 'ContributionSoft',
                'input_type' => 'EntityRef',
                'entity_reference' => [
                  'entity' => 'Contact',
                  'key' => 'id',
                  'on_delete' => 'CASCADE',
                ],
                'required' => FALSE,
                'nullable' => TRUE,
              ],
            ],
          ],
          'tally' => [],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
