<?php

use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Manage_groups',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Manage_groups',
        'label' => E::ts('Manage groups'),
        'api_entity' => 'Group',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'title',
            'created_id.display_name',
            'description',
            'group_type:label',
            'visibility:label',
            'COUNT(Group_GroupContact_Contact_01.display_name) AS COUNT_Group_GroupContact_Contact_01_display_name',
            'saved_search_id',
            'is_active',
            'frontend_title',
            'name',
          ],
          'orderBy' => [],
          'where' => [
            [
              'is_hidden',
              '=',
              FALSE,
            ],
          ],
          'groupBy' => [
            'id',
          ],
          'join' => [
            [
              'Contact AS Group_GroupContact_Contact_01',
              'LEFT',
              'GroupContact',
              [
                'id',
                '=',
                'Group_GroupContact_Contact_01.group_id',
              ],
              [
                'Group_GroupContact_Contact_01.status:name',
                '=',
                '"Added"',
              ],
              [
                'Group_GroupContact_Contact_01.is_deleted',
                '=',
                FALSE,
              ],
            ],
          ],
          'having' => [],
        ],
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Manage_groups_SearchDisplay_Manage_groups',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Manage_groups',
        'label' => E::ts('Manage groups'),
        'saved_search_id.name' => 'Manage_groups',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [
            [
              'title',
              'ASC',
            ],
          ],
          'limit' => 50,
          'pager' => [
            'show_count' => TRUE,
            'expose_limit' => TRUE,
            'hide_single' => TRUE,
          ],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'title',
              'label' => E::ts('Title'),
              'sortable' => TRUE,
              'rewrite' => '',
              'editable' => TRUE,
              'icons' => [],
            ],
            [
              'type' => 'field',
              'key' => 'frontend_title',
              'label' => E::ts('Public Title'),
              'sortable' => TRUE,
              'rewrite' => '',
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'description',
              'label' => E::ts('Description'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'created_id.display_name',
              'label' => E::ts('Created By'),
              'sortable' => TRUE,
              'link' => [
                'path' => '',
                'entity' => 'Contact',
                'action' => 'view',
                'join' => 'created_id',
                'target' => '_blank',
              ],
              'title' => E::ts('View Contact'),
            ],
            [
              'type' => 'field',
              'key' => 'group_type:label',
              'label' => E::ts('Group Type'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'visibility:label',
              'label' => E::ts('Visibility'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'label' => E::ts('Enabled'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'COUNT_Group_GroupContact_Contact_01_display_name',
              'label' => E::ts('Count'),
              'sortable' => TRUE,
              'rewrite' => '{if "[saved_search_id]"}{else}[COUNT_Group_GroupContact_Contact_01_display_name]{/if}',
              'icons' => [
                [
                  'icon' => 'fa-lightbulb',
                  'side' => 'left',
                  'if' => [
                    'saved_search_id',
                    'IS NOT EMPTY',
                  ],
                ],
              ],
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'icon' => 'fa-users',
                  'text' => E::ts('Contacts'),
                  'style' => 'default',
                  'path' => 'civicrm/group/search?reset=1&force=1&context=smog&gid=[id]&component_mode=1',
                  'condition' => [],
                ],
                [
                  'path' => 'civicrm/group/edit?reset=1&action=update&id=[id]',
                  'icon' => 'fa-cog',
                  'text' => E::ts('Settings'),
                  'style' => 'default',
                  'condition' => [],
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => 'crm-popup',
                ],
                [
                  'task' => 'enable',
                  'entity' => 'Group',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'condition' => [],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'Group',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'condition' => [],
                ],
                [
                  'entity' => 'Group',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
            'crm-sticky-header',
          ],
          'toolbar' => [
            [
              'entity' => 'Group',
              'action' => 'add',
              'target' => 'crm-popup',
              'style' => 'primary',
              'text' => E::ts('Add Group'),
              'icon' => 'fa-plus',
            ],
          ],
          'cssRules' => [
            [
              'disabled',
              'is_active',
              '=',
              FALSE,
            ],
          ],
          'hierarchical' => TRUE,
          'collapsible' => 'closed',
        ],
        'acl_bypass' => FALSE,
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
