<?php

use CRM_CivicrmSearchUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Find_Contributions_2',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Find_Contributions_2',
        'label' => E::ts('Find Contributions'),
        'form_values' => NULL,
        'mapping_id' => NULL,
        'search_custom_id' => NULL,
        'api_entity' => 'Contribution',
        'api_params' => [
          'version' => 4,
          'select' => [
            'Contribution_Contact_contact_id_01.display_name',
            'total_amount',
            'financial_type_id:label',
            'source',
            'receive_date',
            'ISNULL(thankyou_date) AS ISNULL_thankyou_date',
            'thankyou_date',
            'contribution_status_id:label',
            'ISNULL(receipt_date) AS ISNULL_receipt_date',
            'ISNULL(contribution_recur_id) AS ISNULL_contribution_recur_id',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => [],
          'join' => [
            [
              'Contact AS Contribution_Contact_contact_id_01',
              'INNER',
              [
                'contact_id',
                '=',
                'Contribution_Contact_contact_id_01.id',
              ],
            ],
            [
              'ContributionSoft AS Contribution_ContributionSoft_contribution_id_01',
              'LEFT',
              [
                'id',
                '=',
                'Contribution_ContributionSoft_contribution_id_01.contribution_id',
              ],
            ],
            [
              'PCP AS Contribution_ContributionSoft_contribution_id_01_ContributionSoft_PCP_pcp_id_01',
              'LEFT',
              [
                'Contribution_ContributionSoft_contribution_id_01.pcp_id',
                '=',
                'Contribution_ContributionSoft_contribution_id_01_ContributionSoft_PCP_pcp_id_01.id',
              ],
            ],
          ],
          'having' => [],
        ],
        'expires_date' => NULL,
        'description' => NULL,
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Find_Contributions_2_SearchDisplay_Find_Contributions_Table_1',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Find_Contributions_Table_1',
        'label' => E::ts('Find Contributions Table 1'),
        'saved_search_id.name' => 'Find_Contributions_2',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'Contribution_Contact_contact_id_01.display_name',
              'label' => E::ts('Name'),
              'sortable' => TRUE,
              'link' => [
                'path' => '',
                'entity' => 'Contact',
                'action' => 'view',
                'join' => 'Contribution_Contact_contact_id_01',
                'target' => '_blank',
              ],
              'title' => E::ts('View Contact'),
              'icons' => [
                [
                  'field' => 'Contribution_Contact_contact_id_01.contact_type:icon',
                  'side' => 'left',
                ],
              ],
            ],
            [
              'type' => 'field',
              'key' => 'total_amount',
              'label' => E::ts('Amount'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'financial_type_id:label',
              'label' => E::ts('Type'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'source',
              'label' => E::ts('Contribution Source'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'receive_date',
              'label' => E::ts('Contribution Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'thankyou_date',
              'label' => E::ts('Thank-you Sent'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'contribution_status_id:label',
              'label' => E::ts('Status'),
              'sortable' => TRUE,
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => 'Contribution',
                  'action' => 'view',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('View'),
                  'style' => 'default',
                  'path' => '',
                  'condition' => [],
                ],
                [
                  'entity' => 'Contribution',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Update'),
                  'style' => 'default',
                  'path' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Send Letter'),
                  'style' => 'default',
                  'path' => 'civicrm/contribute/task?reset=1&task_item=letter&id=[id]',
                  'condition' => [],
                ],
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Send Receipt'),
                  'style' => 'default',
                  'path' => 'civicrm/contribute/task?reset=1&task_item=receipt&id=[id]',
                  'condition' => [],
                ],
                [
                  'entity' => 'Contribution',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
          ],
        ],
        'acl_bypass' => FALSE,
      ],
      'match' => [
        'name',
        'saved_search_id',
      ],
    ],
  ],
];
