<?php

use CRM_CivicrmSearchUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Find_Memberships',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Find_Memberships',
        'label' => E::ts('Find Memberships'),
        'api_entity' => 'Membership',
        'api_params' => [
          'version' => 4,
          'select' => [
            'contact_id.sort_name',
            'membership_type_id:label',
            'join_date',
            'start_date',
            'end_date',
            'source',
            'status_id:label',
            'Membership_ContributionRecur_contribution_recur_id_01.auto_renew',
            'Membership_ContributionRecur_contribution_recur_id_01.contribution_status_id:label',
            'owner_membership_id',
          ],
          'orderBy' => [
            [
              'join_date',
              'DESC',
            ],
          ],
          'where' => [],
          'groupBy' => [],
          'join' => [
            [
              'ContributionRecur AS Membership_ContributionRecur_contribution_recur_id_01',
              'LEFT',
              [
                'contribution_recur_id',
                '=',
                'Membership_ContributionRecur_contribution_recur_id_01.id',
              ],
            ],
            [
              'Contact AS Membership_Contact_contact_id_01',
              'LEFT',
              [
                'contact_id',
                '=',
                'Membership_Contact_contact_id_01.id',
              ],
            ],
            [
              'MembershipStatus AS Membership_MembershipStatus_status_id_01',
              'LEFT',
              [
                'status_id',
                '=',
                'Membership_MembershipStatus_status_id_01.id',
              ],
            ],
          ],
          'having' => [],
        ],
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Find_Memberships_SearchDisplay_Find_Memberships',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Find_Memberships',
        'label' => E::ts('Find Memberships'),
        'saved_search_id.name' => 'Find_Memberships',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'contact_id.sort_name',
              'label' => E::ts('Name'),
              'sortable' => TRUE,
              'link' => [
                'path' => '',
                'entity' => 'Contact',
                'action' => 'view',
                'join' => 'contact_id',
                'target' => '',
              ],
              'title' => E::ts('View Contact'),
            ],
            [
              'type' => 'field',
              'key' => 'membership_type_id:label',
              'label' => E::ts('Type'),
              'sortable' => TRUE,
              'rewrite' => "[membership_type_id:label] {if '[is_primary_member]' === 'No'} (by relationship) {/if}",
            ],
            [
              'type' => 'field',
              'key' => 'join_date',
              'label' => E::ts('Member Since'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'start_date',
              'label' => E::ts('Membership Start Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'end_date',
              'label' => E::ts('Membership Expiration Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'source',
              'label' => E::ts('Membership Source'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'status_id:label',
              'label' => E::ts('Status'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'Membership_ContributionRecur_contribution_recur_id_01.auto_renew',
              'label' => E::ts('Auto Renew'),
              'sortable' => FALSE,
              'alignment' => '',
              'rewrite' => ' ',
              'icons' => [
                [
                  'icon' => 'fa-ban',
                  'side' => 'left',
                  'if' => [
                    'Membership_ContributionRecur_contribution_recur_id_01.contribution_status_id:name',
                    '=',
                    'Cancelled',
                  ],
                ],
                [
                  'icon' => 'fa-check',
                  'side' => 'left',
                  'if' => [
                    'Membership_ContributionRecur_contribution_recur_id_01.contribution_status_id:name',
                    'IS NOT EMPTY',
                  ],
                ],
              ],
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => 'Membership',
                  'action' => 'view',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('View'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'entity' => 'Membership',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Update'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'Membership',
                  'action' => 'view',
                  'join' => 'owner_membership_id',
                  'target' => 'crm-popup',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('View Primary Member'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'entity' => 'Membership',
                  'action' => 'renew',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Renew Membership'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'entity' => 'Membership',
                  'action' => 'followup',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Renew-Credit Card Membership'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'entity' => 'Membership',
                  'action' => 'cancelrecur',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Cancel Auto-renewal'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'entity' => 'Membership',
                  'action' => 'changebilling',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Change Billing Details'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'entity' => 'Membership',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete Membership'),
                  'style' => 'danger',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
          ],
          'headerCount' => TRUE,
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
