<?php

use CRM_Civiimport_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_My_imports',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'My_imports',
        'label' => E::ts('My imports'),
        'form_values' => NULL,
        'mapping_id' => NULL,
        'search_custom_id' => NULL,
        'api_entity' => 'UserJob',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'created_date',
            'expires_date',
            'start_date',
            'end_date',
            'status_id:label',
            'job_type:label',
          ],
          'orderBy' => [],
          'where' => [
            [
              'created_id',
              '=',
              'user_contact_id',
            ],
            [
              'is_template',
              '=',
              FALSE,
            ],
            [
              'is_current',
              '=',
              TRUE,
            ],
          ],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
        'expires_date' => NULL,
        'description' => NULL,
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_My_imports_display',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'My_imports_display',
        'label' => E::ts('My imports'),
        'saved_search_id.name' => 'My_imports',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'id',
              'label' => E::ts('User Job ID'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'created_date',
              'label' => E::ts('Import Job Created Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'expires_date',
              'label' => E::ts('Import Job Expires Date'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'end_date',
              'label' => E::ts('Job Ended Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'status_id:label',
              'label' => E::ts('Job Status'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'job_type:label',
              'label' => E::ts('Job Type'),
              'sortable' => TRUE,
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => 'UserJob',
                  'action' => 'view',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => '',
                  'text' => E::ts('View User Job'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'conditions' => [
                    [
                      'status_id:name',
                      '!=',
                      'draft',
                    ],
                  ],
                ],
                [
                  'size' => 'btn-xs',
                  'links' => [
                    [
                      'entity' => 'UserJob',
                      'action' => 'view',
                      'join' => '',
                      'target' => 'crm-popup',
                      'icon' => '',
                      'text' => E::ts('View User Job'),
                      'style' => 'default',
                      'path' => '',
                      'task' => '',
                      'conditions' => [
                        [
                          'status_id:name',
                          '!=',
                          'draft',
                        ],
                      ],
                    ],
                    [
                      'path' => 'civicrm/import_mapping?id=[id]',
                      'icon' => 'fa-external-link',
                      'text' => E::ts('Continue'),
                      'style' => 'default',
                      'conditions' => [
                        [
                          'status_id:name',
                          'IN',
                          [
                            'draft',
                            'complete_with_errors',
                            'incomplete',
                          ],
                        ],
                        [
                          'job_type:name',
                          '!=',
                          'contact_import',
                        ],
                      ],
                      'task' => '',
                      'entity' => '',
                      'action' => '',
                      'join' => '',
                      'target' => '',
                    ],
                  ],
                  'type' => 'buttons',
                  'alignment' => 'text-right',
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Import_Templates',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Import_Templates',
        'label' => E::ts('Import Templates'),
        'description' => E::ts('Available import templates'),
        'form_values' => NULL,
        'mapping_id' => NULL,
        'search_custom_id' => NULL,
        'api_entity' => 'UserJob',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'created_id.display_name',
            'name',
            'created_date',
            'job_type:label',
          ],
          'orderBy' => [],
          'where' => [
            [
              'is_template',
              '=',
              TRUE,
            ],
          ],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
        'expires_date' => NULL,
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Import_Templates_SearchDisplay_Import_Templates_Table_1',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Import_Templates',
        'label' => E::ts('Import Templates'),
        'saved_search_id.name' => 'Import_Templates',
        'type' => 'table',
        'settings' => [
          'description' => E::ts('Available import templates'),
          'sort' => [],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'id',
              'label' => E::ts('ID'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'created_id.display_name',
              'label' => E::ts('Created By'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'name',
              'label' => E::ts('Import Name'),
              'sortable' => TRUE,
              'link' => [
                'path' => '[job_type:url]?reset=1&template_id=[id]',
                'entity' => '',
                'action' => '',
                'join' => '',
                'target' => '',
              ],
            ],
            [
              'type' => 'field',
              'key' => 'created_date',
              'label' => E::ts('Created Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'job_type:label',
              'label' => E::ts('Type'),
              'sortable' => TRUE,
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Update Template'),
                  'style' => 'default',
                  'path' => 'civicrm/import_mapping?id=[id]',
                  'task' => '',
                  'conditions' => [],
                ],
                [
                  'path' => '[job_type:url]?reset=1&template_id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Use Template'),
                  'style' => 'default',
                  'conditions' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
          ],
        ],
        'acl_bypass' => FALSE,
      ],
      'match' => [
        'name',
        'saved_search_id',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Imports',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'all_imports',
        'label' => 'Imports',
        'form_values' => NULL,
        'mapping_id' => NULL,
        'search_custom_id' => NULL,
        'api_entity' => 'UserJob',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'created_id.display_name',
            'created_date',
            'job_type:label',
            'start_date',
            'end_date',
            'expires_date',
            'status_id:label',
          ],
          'orderBy' => [],
          'where' => [
            [
              'is_template',
              '=',
              FALSE,
            ],
            [
              'is_current',
              '=',
              TRUE,
            ],
          ],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
        'expires_date' => NULL,
        'description' => NULL,
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Import_Templates_SearchDisplay_AllImports',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'all_imports',
        'label' => E::ts('All Imports'),
        'saved_search_id.name' => 'all_imports',
        'type' => 'table',
        'settings' => [
          'description' => E::ts('All import jobs'),
          'sort' => [],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'id',
              'label' => E::ts('ID'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'created_id.display_name',
              'label' => E::ts('Created By'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'name',
              'label' => E::ts('Import Name'),
              'sortable' => TRUE,
              'link' => [
                'path' => '[job_type:url]?reset=1&template_id=[id]',
                'entity' => '',
                'action' => '',
                'join' => '',
                'target' => '',
              ],
            ],
            [
              'type' => 'field',
              'key' => 'created_date',
              'label' => E::ts('Created Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'expires_date',
              'label' => E::ts('Expires Date'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'job_type:label',
              'label' => E::ts('Type'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'status_id:label',
              'label' => E::ts('Status'),
              'sortable' => TRUE,
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => 'UserJob',
                  'action' => 'view',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => '',
                  'text' => E::ts('View User Job'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'conditions' => [
                    [
                      'status_id:name',
                      '!=',
                      'draft',
                    ],
                  ],
                ],
                [
                  'path' => 'civicrm/import_mapping?id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Continue'),
                  'style' => 'default',
                  'conditions' => [
                    [
                      'status_id:name',
                      'IN',
                      [
                        'draft',
                        'complete_with_errors',
                        'incomplete',
                      ],
                    ],
                    [
                      'job_type:name',
                      '!=',
                      'contact_import',
                    ],
                  ],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
          ],
        ],
        'acl_bypass' => FALSE,
      ],
      'match' => [
        'name',
        'saved_search_id',
      ],
    ],
  ],
];
