(function(angular, $, _) {
  "use strict";

  // Register hooks on the crmSearchAdmin component
  angular.module('crmSearchAdmin').decorator('crmSearchAdminDirective', function($delegate, crmApi4, searchMeta) {
    // Register callback for preSaveDisplay hook
    $delegate[0].controller.hook.findCriticalChanges.push(function(display, data) {
      if (!display.original) return;
      if (display.original.type !== 'entity') return;
      const entityLabel = display.updated.label || display.updated.name || ts('(Unnamed)');

      if (!display.updated || display.updated.trashed) {
        data.messages.push(ts('Remove DB entity "%1".', {1: entityLabel}));
        return;
      }

      function getColNames(cols) {
        const result = {};
        _.forEach(cols, function(col) {
          result[col.key] = col.name || searchMeta.createSqlName(col.key);
          // We don't have the formula for the autogenerated column name, but "(key)" is a near+stable facsimile.
          // col.spec.name is close, but it's not guaranteed to be available+consistent.
        });
        return result;
      }
      const oldNames = getColNames(display.original.settings.columns);
      const newNames = getColNames(display.updated.settings.columns);
      const removed = _.difference(_.keys(oldNames), _.keys(newNames));
      const changed = _.filter(_.keys(oldNames), (srcKey) =>  newNames[srcKey] && newNames[srcKey] != oldNames[srcKey]);

      removed.forEach(function(srcKey) {
        data.messages.push(ts('In entity "%1", remove column "%2".', {1: entityLabel, 2: oldNames[srcKey]}));
      });
      changed.forEach(function(srcKey) {
        data.messages.push(ts('In entity "%1", rename column "%2" to "%3".', {1: entityLabel, 2: oldNames[srcKey], 3: newNames[srcKey]}));
      });
    });
    $delegate[0].controller.hook.preSaveDisplay.push(function(display, apiCalls) {
      if (display.type === 'entity') {
        // Unset vars added by the preview (see `crmSearchDisplayEntity`)
        delete display.settings.limit;
        delete display.settings.pager;
        delete display.settings.classes;
      }
      if (display.type === 'entity' && display._job) {
        // Add/update scheduled job
        display._job.api_entity = 'SK_' + display.name;
        display._job.api_action = 'refresh';
        display._job.name = ts('Refresh %1 Table', {1: display.label});
        display._job.description = ts('Refresh contents of the %1 SearchKit entity', {1: display.label});
        apiCalls['job_' + display.name] = ['Job', 'save', {
          records: [display._job],
          match: ['api_entity', 'api_action']
        }, 0];
      }
    });
    // Register callback for postSaveDisplay hook
    $delegate[0].controller.hook.postSaveDisplay.push(function(display, apiResults) {
      if (display.type === 'entity') {
        // Refresh entity displays which write to SQL tables. Do this asynchronously because it can be slow.
        crmApi4('SK_' + display.name, 'refresh', {}, 0).then(function(result) {
          display._refresh_date = CRM.utils.formatDate(result.refresh_date, null, true);
        });
        // Job was a separate api call, add its result back in to the model
        if (apiResults['job_' + display.name]) {
          display._job = apiResults['job_' + display.name];
        }
        // Refresh admin settings to reflect any new/updated entity + joins
        fetch(CRM.url('civicrm/ajax/admin/search'))
          .then(response => response.json())
          .then(data => CRM.crmSearchAdmin = data);
      }
    });
    return $delegate;
  });

})(angular, CRM.$, CRM._);
