<?php

return [
  [
    'name' => 'SavedSearch_Administer_Site_Tokens',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Site_Tokens',
        'label' => ts('Administer Site Tokens'),
        'api_entity' => 'SiteToken',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'is_active',
            'name',
            'label',
            'is_reserved',
          ],
          'orderBy' => [],
          'where' => [
            [
              'domain_id:name',
              '=',
              'current_domain',
            ],
          ],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_Site_Tokens_SearchDisplay_Administer_Site_Tokens_Table_1',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Site_Tokens_Table_1',
        'label' => ts('Administer Site Tokens'),
        'saved_search_id.name' => 'Administer_Site_Tokens',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [
            [
              'label',
              'ASC',
            ],
          ],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'id',
              'label' => ts('ID'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'label',
              'label' => ts('Label'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'name',
              'label' => ts('Token String'),
              'sortable' => TRUE,
              'rewrite' => '{ldelim}site.[name]{rdelim}',
            ],
            [
              'type' => 'field',
              'key' => 'is_reserved',
              'label' => ts('Reserved'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'label' => ts('Enabled'),
              'sortable' => TRUE,
              'cssRules' => [],
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => 'SiteToken',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => ts('Edit'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'delete',
                  'entity' => 'SiteToken',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'action' => '',
                  'condition' => [
                    'is_reserved',
                    '=',
                    FALSE,
                  ],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'SiteToken',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => ts('Enable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [
                    'is_active',
                    '=',
                    FALSE,
                  ],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'SiteToken',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => ts('Disable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [
                    'is_active',
                    '=',
                    TRUE,
                  ],
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
          ],
          'cssRules' => [
            [
              'disabled',
              'is_active',
              '=',
              FALSE,
            ],
          ],
          'toolbar' => [
            [
              'entity' => 'SiteToken',
              'text' => ts('Add Site Token'),
              'icon' => 'fa-plus',
              'target' => 'crm-popup',
              'action' => 'add',
              'style' => 'primary',
              'join' => '',
              'path' => '',
              'task' => '',
              'condition' => [],
            ],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
