# CiviCRM 6.6.0

Released September 3, 2025;

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add filters to Administer Scheduled Reminders
  ([33129](https://github.com/civicrm/civicrm-core/pull/33129))**

  Adds filers to the "Administer Scheduled Reminders".

- **Use Civiimport for activity import
  ([32524](https://github.com/civicrm/civicrm-core/pull/32524) and
  [33190](https://github.com/civicrm/civicrm-core/pull/33190))**

  Switches to using CiviImport for activity imports.

- **Add cross contact-type email import support
  ([33150](https://github.com/civicrm/civicrm-core/pull/33150))**

  Adds cross contact-type email import support.

- **SearchKit - Inline-edit creation of contact primary phone/email/address
  ([33187](https://github.com/civicrm/civicrm-core/pull/33187))**

  Makes it so one can create primary phone, email and address records from
  inline edit in searchkit.

- **SearchKit - Add css classes to editable table cells
  ([33157](https://github.com/civicrm/civicrm-core/pull/33157))**

  Improves SearchKit css classes for editable table cells, for theming purposes.

- **SearchKit - Show entityRef links when appropriate
  ([33264](https://github.com/civicrm/civicrm-core/pull/33264))**

  Improves extra options on Autocomplete fields.

- **allow configuring No results message for list displays
  ([33166](https://github.com/civicrm/civicrm-core/pull/33166))**

  Copies functionality from searchkit table display to list display.

- **SearchKit - add task for adding relationships
  ([33314](https://github.com/civicrm/civicrm-core/pull/33314))**

  Adds a new relationship task to SearchKit.

- **SearchKit UX: SearchKit UI Permissions
  ([dev/core#5878](https://lab.civicrm.org/dev/core/-/issues/5878):
  [32885](https://github.com/civicrm/civicrm-core/pull/32885))**

  Adds an additional set of permissions for general staff members who don't need
  full CiviCRM permissions. It allows them to only edit/delete their own SK
  items, but not those created by others.

- **SearchKitBatch - Set default amount for soft credits from contribution total
  ([33144](https://github.com/civicrm/civicrm-core/pull/33144))**

  When importing contribution with soft credit, this fills in the soft credit
  amount with the contribution total if not otherwise specified.

- **SearchKit Batch - Add target totals
  ([33234](https://github.com/civicrm/civicrm-core/pull/33234))**

  Makes it so an admin can set fields to accept target amounts, which will be
  softly enforced before running the import.

- **SearchKit Batch - Add required field validation
  ([33226](https://github.com/civicrm/civicrm-core/pull/33226))**

  For SearchKit batch entry displays, allows fields to be set as required and
  validates them before running the import.

- **SearchKitBatch - More efficient saving
  ([33266](https://github.com/civicrm/civicrm-core/pull/33266))**

  Makes SearchKit Batch saving more efficient.

- **Afform: Make it possible that the token with link to the form contains extra
  context information
  ([dev/core#5837](https://lab.civicrm.org/dev/core/-/issues/5837):
  [32599](https://github.com/civicrm/civicrm-core/pull/32599))**

  Makes it so that when a link to a formbuilder form is created one can add
  extra context information.

- **Api4 - Allow fields to be specified by reload option
  ([33246](https://github.com/civicrm/civicrm-core/pull/33246))**

  Updates the setReload method across multiple actions to allow specifying an
  array of fields for reloading instead of a simple boolean. This allows extra
  fields and pseudoconstant suffixes to be included in the reloaded result.

- **Api4 - Add GROUP_NTH sql function
  ([33249](https://github.com/civicrm/civicrm-core/pull/33249))**

  Adds the ability to select Nth item in a grouping to APIv4.

- **Api4 - Make primary email/phone/address/im fields writable
  ([33284](https://github.com/civicrm/civicrm-core/pull/33284))**

  Exposes the primary fields to getFields for all actions not just get. Allows
  primary entities to be updated by id as well.

- **SearchKit - Improve styling of batch entry
  ([33265](https://github.com/civicrm/civicrm-core/pull/33265))**

  Improves styling of searchkit batch entry.

- **Api Explorer - Improve theming in Riverlea
  ([33261](https://github.com/civicrm/civicrm-core/pull/33261))**

  Improves Riverlea styling of the APIv4 Explorer.

- **RiverLea - Inline edit padding & input sizes, to make batch input look more
  spreadsheety ([33165](https://github.com/civicrm/civicrm-core/pull/33165))**

  Makes SearchKit batch screens look more spreadsheet like for sites using
  RiverLea.

- **RiverLea: improve inline edit - icon for empty inline edit, wrap controls,
  shrink input ([33152](https://github.com/civicrm/civicrm-core/pull/33152))**

  Improves inline edit experience for sites using SearchKit.

- **Riverlea - add Stream entity
  ([32127](https://github.com/civicrm/civicrm-core/pull/32127))**

  Moves the Stream definitions in Riverlea from hard-coded to a new entity.

- **RiverLea Proposal for some functional classes
  ([dev/core#5966](https://lab.civicrm.org/dev/core/-/issues/5966):
  [33118](https://github.com/civicrm/civicrm-core/pull/33118))**

  Adds utility positioning classes for Flexbox to RiverLea.

- **Riverlea: Add variable for dashboard columns, make 40/60 default
  ([33115](https://github.com/civicrm/civicrm-core/pull/33115))**

  Improves display of dashboards for sites using Riverlea.

- **RiverLea: makes inactive/disabled row state clearer visually
  ([33278](https://github.com/civicrm/civicrm-core/pull/33278))**

  Makes inactive/disabled row state easier to distinguish.

- **RiverLea - Improve field width handling
  ([33252](https://github.com/civicrm/civicrm-core/pull/33252))**

  Improves the SearchKit UI by setting sensible input widths, enabling
  inline-forms to appear much less cluttered.

- **Improve error when object not found
  ([33217](https://github.com/civicrm/civicrm-core/pull/33217))**

  Improves the error messaging when object cannot be found.

- **CiviImport - Add icons & labels on import screen
  ([33406](https://github.com/civicrm/civicrm-core/pull/33406))**

  Accessibility improvements & icons for the import screen.

- **Add (basic) import actions
  ([33308](https://github.com/civicrm/civicrm-core/pull/33308))**

  Makes it so any Contact in any civiimport can be added to a group.

- **CiviImport - Allow multiple dedupe rules to be selected
  ([33328](https://github.com/civicrm/civicrm-core/pull/33328))**

  Alters the CIviImport UI to allow multiple dedupe rules.

- **Autocomplete - Allow default display per entity
  ([33203](https://github.com/civicrm/civicrm-core/pull/33203))**

  Allows admins to customize autocomplete dropdowns.

- **Small not a dupe UX improvements
  ([33123](https://github.com/civicrm/civicrm-core/pull/33123))**

  Improves user experience when marking a pair as not a duplicate.

- **Add new UserJob statuses for incomplete import
  ([33299](https://github.com/civicrm/civicrm-core/pull/33299))**

  Adds a new UserJob status for incomplete imports.

- **Update ReflectionUtils::parseDocBlock to handle array shapes
  ([33286](https://github.com/civicrm/civicrm-core/pull/33286))**

  Updates ReflectionUtils::parseDocBlock to handle array shapes.

- **Add support for complex array parsing to codeDocs
  ([33288](https://github.com/civicrm/civicrm-core/pull/33288))**

  Adds support for nested array shapes.

- **Add support for generic imports
  ([33273](https://github.com/civicrm/civicrm-core/pull/33273))**

  Adds support for imports of any generic civicrm entity.

- **Add ability to continue imports from import listing
  ([33270](https://github.com/civicrm/civicrm-core/pull/33270))**

  Adds ability to continue imports from the import listing.

- **Add ability to update import templates
  ([33259](https://github.com/civicrm/civicrm-core/pull/33259))**

  Adds the ability to update import templates.

- **Add Civiimport Preview form, reduce code duplication
  ([33267](https://github.com/civicrm/civicrm-core/pull/33267))**

  Adds a CiviImport preview screen.

- **Add support for first match in deduping
  ([33257](https://github.com/civicrm/civicrm-core/pull/33257))**

  Adds support for picking the first match when deduping.

- **Add required & enabled to Admin UI custom field form
  ([33250](https://github.com/civicrm/civicrm-core/pull/33250))**

  Adds required & enabled to Admin UI custom field form.

- **Autocomplete - Configurable multi-field search without UNION or OR  
  ([33237](https://github.com/civicrm/civicrm-core/pull/33237))**

  New, improved Autocomplete architecture allows greater configurability and
  efficiency.

### CiviCase

- **CiviCase - Add SearchKit task for adding case roles
  ([33298](https://github.com/civicrm/civicrm-core/pull/33298))**

  Add searchkit task for adding case roles.

- **FormBuilder: autofil case based on the case being viewed
  ([dev/core#5838](https://lab.civicrm.org/dev/core/-/issues/5838):
  [32600](https://github.com/civicrm/civicrm-core/pull/32600))**

  Makes it so one can autofill a formbuilder with a case.

- **Form Builder: load related contact based on a role on a CiviCase
  ([dev/core#5832](https://lab.civicrm.org/dev/core/-/issues/5832):
  [32594](https://github.com/civicrm/civicrm-core/pull/32594))**

  Makes it so one can conditionally load formbuilder content based on a CiviCase
  role.

- **Add some more deprecated variables to the warning list
  ([33221](https://github.com/civicrm/civicrm-core/pull/33221))**

  Flags deprecated tokens so that end users who use them get a system status
  warning.

### CiviContribute

- **Add invoice tokens to the deprecation list
  ([33220](https://github.com/civicrm/civicrm-core/pull/33220))**

  Flags deprecated tokens so that end users who use them get a system status
  warning.

- **Add new Contribution data entry batch, in extension
  ([33210](https://github.com/civicrm/civicrm-core/pull/33210) and
  [33143](https://github.com/civicrm/civicrm-core/pull/33143))**

  Adds a new contribution data entry batch screen via extension.

- **Add support for importing payment_field in contribution import
  ([33305](https://github.com/civicrm/civicrm-core/pull/33305))**

  Makes it so you can import a `payment_field` in the contribution import.

- **Move contribution import action to Mapping screen
  ([33136](https://github.com/civicrm/civicrm-core/pull/33136))**

  When importing contributions, this moves the "Import Action" field to the
  Mapping screen.

### Standalone Integration

- **Standalone - Add nav menu for 'User Permissions'
  ([33276](https://github.com/civicrm/civicrm-core/pull/33276))**

  Adds an item to the "Users and Permissions" nav menu in standalone which lets
  you go directly to the permissions screen instead of needing to click through
  the User Roles screen first.

- **Standalone - print "Path not found" for non-civicrm routes
  ([33331](https://github.com/civicrm/civicrm-core/pull/33331))**

  Better error message when a non-civicrm route is tried.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Custom fields for contact subtype also required for parent contact type
  ([dev/core#6054](https://lab.civicrm.org/dev/core/-/issues/6054):
  [33441](https://github.com/civicrm/civicrm-core/pull/33441))**

- **Formbuilder: entity reference is not displayed as a label (name) when there is
  an initial value and the field setting is "display only"
  ([dev/core#5424](https://lab.civicrm.org/dev/core/-/issues/5424):
  [33449](https://github.com/civicrm/civicrm-core/pull/33449))**

- **MailingEventForward.php is missing in 6.5 but called from
  Civi/Api4/Service/Spec/Provider/MailingGetSpecProvider.php:189
  ([dev/core#6067](https://lab.civicrm.org/dev/core/-/issues/6067:
  [33474](https://github.com/civicrm/civicrm-core/pull/33474))**

- **gracefully handle google geocoding failures
  ([33248](https://github.com/civicrm/civicrm-core/pull/33248))**

- **Properly replicate managed entities when not all domains are multisite
  enabled ([32751](https://github.com/civicrm/civicrm-core/pull/32751))**

- **If one scheduled reminder fails to process log and continue with the others
  ([33128](https://github.com/civicrm/civicrm-core/pull/33128))**

- **Replace "Edit Profile" BackBone popup
  ([dev/core#4349](https://lab.civicrm.org/dev/core/-/issues/4349):
  [33076](https://github.com/civicrm/civicrm-core/pull/33076))**

- **Search for Related Contacts (RelationshipCache) doesn't show subsets of
  Actions options
  ([dev/core#5483](https://lab.civicrm.org/dev/core/-/issues/5483):
  [33140](https://github.com/civicrm/civicrm-core/pull/33140))**

- **Formbuilder: Search results are not displayed (only the header) when the
  search form is accessed through message token (in a mail)
  ([dev/core#5960](https://lab.civicrm.org/dev/core/-/issues/5960):
  [33162](https://github.com/civicrm/civicrm-core/pull/33162))**

- **Fix race condition when loading row count in SearchKit
  ([dev/core#5965](https://lab.civicrm.org/dev/core/-/issues/5965):
  [33282](https://github.com/civicrm/civicrm-core/pull/33282))**

- **SearchKit - Remove unused dataType from search display columns
  ([dev/core#5974](https://lab.civicrm.org/dev/core/-/issues/5974):
  [30938](https://github.com/civicrm/civicrm-core/pull/30938))**

- **SearchUI: "Name and Email" field is missing
  ([dev/core#5991](https://lab.civicrm.org/dev/core/-/issues/5991):
  [33169](https://github.com/civicrm/civicrm-core/pull/33169) and
  [33205](https://github.com/civicrm/civicrm-core/pull/33205))**

- **Duplicate emails sent by SearchKit-based Scheduled Reminders
  ([dev/core#5994](https://lab.civicrm.org/dev/core/-/issues/5994):
  [33168](https://github.com/civicrm/civicrm-core/pull/33168))**

- **riverlea: New site always warns about a pending extension upgrade
  ([dev/core#5996](https://lab.civicrm.org/dev/core/-/issues/5996):
  [33223](https://github.com/civicrm/civicrm-core/pull/33223))**

- **SearchKit / API4 - Multivalue contact reference field - IS EMPTY / IS NOT
  EMPTY doesn't display proper results
  ([dev/core#5998](https://lab.civicrm.org/dev/core/-/issues/5998):
  [33173](https://github.com/civicrm/civicrm-core/pull/33173))**

- **Searchkit drag and drop sorting doesn't work in Safari browser
  ([dev/core#6018](https://lab.civicrm.org/dev/core/-/issues/6018):
  [33304](https://github.com/civicrm/civicrm-core/pull/33304))**

- **Contacts with no first/last name appear twice in QuickSearch
  ([dev/core#6043](https://lab.civicrm.org/dev/core/-/issues/6043):
  [33342](https://github.com/civicrm/civicrm-core/pull/33342))**

- **SearchKit Admin List Permission regression
  ([dev/core#6044](https://lab.civicrm.org/dev/core/-/issues/6044):
  [33351](https://github.com/civicrm/civicrm-core/pull/33351))**

- **Performance/caching of AbstractEntity::getInfo
  ([dev/core#6053](https://lab.civicrm.org/dev/core/-/issues/6053):
  [33389](https://github.com/civicrm/civicrm-core/pull/33389))**

  Reverts static cache in AbstractEntity::getInfo.

- **RiverLea, Thames: Removes Form Builder colour over-ride rendering dropdown
  'danger' links illegible
  ([33219](https://github.com/civicrm/civicrm-core/pull/33219))**

- **RiverLea: Responsive improvement : container query on contact summary stacks
  label/value ([33100](https://github.com/civicrm/civicrm-core/pull/33100))**

- **RiverLea: change Empty Stream to remove outdated variables and give basic
  pointers ([33126](https://github.com/civicrm/civicrm-core/pull/33126))**

- **Small Riverlea fixes: Tab count padding and front end radio alignment
  ([33043](https://github.com/civicrm/civicrm-core/pull/33043))**

- **RiverLea: menus unreachable under notifications
  ([33046](https://github.com/civicrm/civicrm-core/pull/33046))**

- **RiverLea applies 'inactive' colour variable on Select2 placeholder text
  ([33251](https://github.com/civicrm/civicrm-core/pull/33251))**

- **Fix RiverLea theming issues
  ([33047](https://github.com/civicrm/civicrm-core/pull/33047))**

- **RiverLea: sets min-width on select2 dropdown, adds top border, fixes select
  border-radius variable name error
  ([33244](https://github.com/civicrm/civicrm-core/pull/33244))**

- **RiverLea: right-align icon in control columns on disabled table rows
  ([33335](https://github.com/civicrm/civicrm-core/pull/33335))**

- **RiverLea: SearchKit, dont reverse table cell with text-right
  ([33336](https://github.com/civicrm/civicrm-core/pull/33336))**

- **Riverlea, fixes colour issue on disabled table row buttons and icons
  ([33326](https://github.com/civicrm/civicrm-core/pull/33326))**

- **Riverlea - fix civicrm override loading in Walbrook/Thames
  ([33394](https://github.com/civicrm/civicrm-core/pull/33394))**

- **RiverLea: two colour contrast bug fixes: FB dropdown trash icon &
  notification link
  ([33245](https://github.com/civicrm/civicrm-core/pull/33245))**

- **Api4 - Ensure the 'user_contact_id' placeholder works for both read & write
  ([33285](https://github.com/civicrm/civicrm-core/pull/33285))**

- **Api4 - Fix DAO fields_callback handling of default value
  ([33446](https://github.com/civicrm/civicrm-core/pull/33446))**

- **Afform - Set format of DisplayOnly fields based on input type
  ([33139](https://github.com/civicrm/civicrm-core/pull/33139))**

- **FormBuilder - Fix using readonly fields as filters
  ([33413](https://github.com/civicrm/civicrm-core/pull/33413))**

- **SearchKit - Fix adding link conditions
  ([33440](https://github.com/civicrm/civicrm-core/pull/33440))**

- **SearchKit - Fix size of page size input
  ([33311](https://github.com/civicrm/civicrm-core/pull/33311))**

- **[SearchKit] Use native data types in spreadsheet export
  ([32766](https://github.com/civicrm/civicrm-core/pull/32766))**

- **SearchKitBatch - Fix setting initial defaults
  ([33262](https://github.com/civicrm/civicrm-core/pull/33262))**

- **SearchKit Batch - Fix e-notice in serialized field handling
  ([33247](https://github.com/civicrm/civicrm-core/pull/33247))**

- **SearchKit Batch - Fix target totals confirmation
  ([33235](https://github.com/civicrm/civicrm-core/pull/33235))**

- **SearchKit Batch - Fix serialized fields
  ([33232](https://github.com/civicrm/civicrm-core/pull/33232))**

- **Use default Redis handler if configured
  ([33354](https://github.com/civicrm/civicrm-core/pull/33354))**

- **Return a more helpful server side validation message
  ([25823](https://github.com/civicrm/civicrm-core/pull/25823))**

- **Handle legacy user jobs with no baseEntity
  ([33346](https://github.com/civicrm/civicrm-core/pull/33346))**

- **Profile: location types
  ([33277](https://github.com/civicrm/civicrm-core/pull/33277))**

  Fixes a bug when there are multiple phone numbers in a profile with different
  location types.

- **Add datasource.tpl not added to previous commit (gitfoo fail)
  ([33240](https://github.com/civicrm/civicrm-core/pull/33240))**

- **Always call constructor for ECK entities so we always have valid field
  definitions and joins work
  ([33263](https://github.com/civicrm/civicrm-core/pull/33263))**

- **Switch Search operator to CONTAINS on text fields in Admin UI
  ([33207](https://github.com/civicrm/civicrm-core/pull/33207))**

- **AdminUI - Consistently set 'disabled' class on table row, not cell
  ([33341](https://github.com/civicrm/civicrm-core/pull/33341))**

- **Standardise template presentation of billing name & address
  ([33148](https://github.com/civicrm/civicrm-core/pull/33148))**

- **Mail : correct docblock of formatFromAddress
  ([33330](https://github.com/civicrm/civicrm-core/pull/33330))**

- **Fix permission denied in logs when uninstalling extension
  ([33260](https://github.com/civicrm/civicrm-core/pull/33260))**

- **CustomField - Avoid crash when blank value is passed to format date
  ([33421](https://github.com/civicrm/civicrm-core/pull/33421))**

- **Update _form.css to make snooze date easy to view
  ([33051](https://github.com/civicrm/civicrm-core/pull/33051))**

- **Autocomplete - Fix default display setting and add test
  ([33241](https://github.com/civicrm/civicrm-core/pull/33241))**

- **Stop telling me I don't know about Berlin
  ([33233](https://github.com/civicrm/civicrm-core/pull/33233))**

- **ChartKit - Move admin to its own module
  ([33130](https://github.com/civicrm/civicrm-core/pull/33130))**

  Prevents Admin js from loading on the frontend.

- **Stop assigning paidBy variable to receipt templates
  ([33216](https://github.com/civicrm/civicrm-core/pull/33216))**

- **fix unnecessary dialog bottom margin when no buttons
  ([33310](https://github.com/civicrm/civicrm-core/pull/33310))**

- **Core - Fix date comparison in duplicate relationship check.
  ([33315](https://github.com/civicrm/civicrm-core/pull/33315))**

- **Stop saving Mapping entity from Civiimport imports
  ([33197](https://github.com/civicrm/civicrm-core/pull/33197))**

- **Import: do not crash if importing an invalid country
  ([33329](https://github.com/civicrm/civicrm-core/pull/33329))**

- **Stop generating Import Summary searches
  ([33393](https://github.com/civicrm/civicrm-core/pull/33393))**

- **Don't overwrite (or duplicate) custom fields on Profile submission
  ([25694](https://github.com/civicrm/civicrm-core/pull/25694))**

- **fix bottom margin for dialogs with buttonpane
  ([33332](https://github.com/civicrm/civicrm-core/pull/33332))**

- **Further fix on handling of the default values for added import rows
  ([33294](https://github.com/civicrm/civicrm-core/pull/33294))**

- **Fix default dedupe rule adjust to move to MapField
  ([33229](https://github.com/civicrm/civicrm-core/pull/33229))**

- **Fix for deprecation notice when updating older UserJobs
  ([33355](https://github.com/civicrm/civicrm-core/pull/33355))**

- **Do not display 'Continue' for Contact imports
  ([33379](https://github.com/civicrm/civicrm-core/pull/33379))**

- **Profile Groups: fix Used For field
  ([33087](https://github.com/civicrm/civicrm-core/pull/33087))**

- **Fix menubar search; use UNIONs for performance
  ([33258](https://github.com/civicrm/civicrm-core/pull/33258))**

- **fix issue when contact subtype is added via import
  ([33208](https://github.com/civicrm/civicrm-core/pull/33208))**

- **Tagset - Fix js error when creating new tag
  ([33269](https://github.com/civicrm/civicrm-core/pull/33269))**

- **fix missing span tag
  ([33155](https://github.com/civicrm/civicrm-core/pull/33155))**

- **Start to separate Civiimport parser functions from shared parent
  ([33239](https://github.com/civicrm/civicrm-core/pull/33239))**

- **Make formatting more consistent in import
  ([33178](https://github.com/civicrm/civicrm-core/pull/33178))**

- **Make import icons consistent
  ([33135](https://github.com/civicrm/civicrm-core/pull/33135))**

- **Upgrader - Tighten bolts to prevent bad/premature reconciliations
  ([33124](https://github.com/civicrm/civicrm-core/pull/33124))**

- **Fix help link on "Multi Site Preferences" screen
  ([33122](https://github.com/civicrm/civicrm-core/pull/33122))**

- **Move contact type to MapField, permit id-only match
  ([33054](https://github.com/civicrm/civicrm-core/pull/33054))**

- **Fix typo
  ([33242](https://github.com/civicrm/civicrm-core/pull/33242))**

- **Fix overzealous redirect fix
  ([33306](https://github.com/civicrm/civicrm-core/pull/33306))**

- **Remove redundant message variables
  ([33149](https://github.com/civicrm/civicrm-core/pull/33149))**

- **use meta rather than string concatenation for af-field ng-include
  ([33127](https://github.com/civicrm/civicrm-core/pull/33127))**

- **Consolidate ContributionParser & CiviimportParser getMappedRow
  ([33291](https://github.com/civicrm/civicrm-core/pull/33291))**

### CiviContribute

- **Move dateFormat from DataSource form to MapField form
  ([33227](https://github.com/civicrm/civicrm-core/pull/33227))**

- **Move validateContactFields from generic MapField parent to CiviImport parent
  ([33230](https://github.com/civicrm/civicrm-core/pull/33230))**

- **Add payment for batch data import
  ([33021](https://github.com/civicrm/civicrm-core/pull/33021))**

- **Fix Message Preview crash on sites with only quick config pricesets
  ([33356](https://github.com/civicrm/civicrm-core/pull/33356))**

- **bug fix Pay Later text not replaced when payment is moved to Confirmation
  ([33309](https://github.com/civicrm/civicrm-core/pull/33309) and
  [33319](https://github.com/civicrm/civicrm-core/pull/33319))**

- **set Contribution default search columns explicitly, include receive_date
  ([33167](https://github.com/civicrm/civicrm-core/pull/33167))**

- **Remove fallback to quickform from Contribution parser
  ([33195](https://github.com/civicrm/civicrm-core/pull/33195))**

- **CiviPledge Report undefined array key
  ([dev/core#6004](https://lab.civicrm.org/dev/core/-/issues/6004):
  [33231](https://github.com/civicrm/civicrm-core/pull/33231))**

- **Update soft credit exception check
  ([33427](https://github.com/civicrm/civicrm-core/pull/33427))**

### CiviEvent

- **Fix fatal error when event is free
  ([33417](https://github.com/civicrm/civicrm-core/pull/33417))**

### CiviMember

- **Remove handling for back-office renewal for form not called from there
  ([33186](https://github.com/civicrm/civicrm-core/pull/33186))**

- **Fix Inherited Memberships To Respect Multiple Qualifying Relationships
  ([31886](https://github.com/civicrm/civicrm-core/pull/31886))**

- **Membership Import creates duplicate contact records
  ([dev/core#6065](https://lab.civicrm.org/dev/core/-/issues/6065):
  [33437](https://github.com/civicrm/civicrm-core/pull/33437) and
  [33435](https://github.com/civicrm/civicrm-core/pull/33435))**

### Standalone Integration

- **standalone: smarty errors don't display on screen
  ([dev/core#5983](https://lab.civicrm.org/dev/core/-/issues/5983):
  [33120](https://github.com/civicrm/civicrm-core/pull/33120))**

## <a name="misc"></a>Miscellany

- **Update PHPOffice/PHPSpreadsheet to 1.30  
  ([33471](https://github.com/civicrm/civicrm-core/pull/33471))**

- **Replace tokenClasse with more generic getClassesByProperty
  ([33272](https://github.com/civicrm/civicrm-core/pull/33272))**

- **CustomField - Add code comments to clarify shortName and longName
  ([33327](https://github.com/civicrm/civicrm-core/pull/33327))**

- **CustomField - Add method to retrieve custom field by name
  ([33318](https://github.com/civicrm/civicrm-core/pull/33318))**

- **Move more functions to civiimport ImportParser
  ([33255](https://github.com/civicrm/civicrm-core/pull/33255))**

- **updated deleted files
  ([33412](https://github.com/civicrm/civicrm-core/pull/33412))**

- **Stop passing form to no-longer-shared function
  ([33253](https://github.com/civicrm/civicrm-core/pull/33253))**

- **Move api call from apiv3 to apiv4
  ([33181](https://github.com/civicrm/civicrm-core/pull/33181))**

- **RiverLea: Updates ReadMe to point to docs site and remove most of its
  content ([33316](https://github.com/civicrm/civicrm-core/pull/33316))**

- **Fix comments to specify form, remove pass-by-ref
  ([33192](https://github.com/civicrm/civicrm-core/pull/33192))**

- **Consolidate constant on CRM_Import_Parser
  ([33243](https://github.com/civicrm/civicrm-core/pull/33243))**

- **Reduce passing on financialType object
  ([33180](https://github.com/civicrm/civicrm-core/pull/33180))**

- **Unshare import getDedupeRule function
  ([33381](https://github.com/civicrm/civicrm-core/pull/33381))**

- **Move some civi-import only functions to CiviImport
  ([33238](https://github.com/civicrm/civicrm-core/pull/33238))**

- **Fix typos in contribution/creditnote settings
  ([33236](https://github.com/civicrm/civicrm-core/pull/33236))**

- **Unshare Civiimport duplicate handling from Contact
  ([33362](https://github.com/civicrm/civicrm-core/pull/33362))**

- **Update pear/db to latest (1.12.2) - Remove overly aggressive patching
  ([33344](https://github.com/civicrm/civicrm-core/pull/33344))**

- **Clean up entity_data tracking in import
  ([33274](https://github.com/civicrm/civicrm-core/pull/33274))**

- **add MundMBo to contributor-key.yml
  ([33350](https://github.com/civicrm/civicrm-core/pull/33350))**

- **Unshare & simplify overly-complex shared function
  ([33185](https://github.com/civicrm/civicrm-core/pull/33185))**

- **Remove tracking function
  ([33215](https://github.com/civicrm/civicrm-core/pull/33215))**

- **Remove redundant membership load in order.complete
  ([33182](https://github.com/civicrm/civicrm-core/pull/33182))**

- **remove deprecated functions from CustomGroup BAO
  ([33280](https://github.com/civicrm/civicrm-core/pull/33280))**

- **Remove legacy contribution type assignment
  ([33147](https://github.com/civicrm/civicrm-core/pull/33147))**

- **Remove / fix highlightedFields handling
  ([33228](https://github.com/civicrm/civicrm-core/pull/33228))**

- **Remove deprecated test function
  ([33146](https://github.com/civicrm/civicrm-core/pull/33146))**

- **Remove calls to addSavedMappingFields
  ([33300](https://github.com/civicrm/civicrm-core/pull/33300))**

- **Remove unused js calls from Civiimport Datasource.tpl
  ([33292](https://github.com/civicrm/civicrm-core/pull/33292))**

- **Remove implicit permission
  ([33206](https://github.com/civicrm/civicrm-core/pull/33206))**

- **Remove functions deprecated by flexmailer
  ([33116](https://github.com/civicrm/civicrm-core/pull/33116))**

- **Remove deprecated property with no universe accessors
  ([33176](https://github.com/civicrm/civicrm-core/pull/33176))**

- **Remove functions deprecated in early 2024
  ([33183](https://github.com/civicrm/civicrm-core/pull/33183))**

- **Remove some non-functional code
  ([33275](https://github.com/civicrm/civicrm-core/pull/33275))**

- **Remove trait noisily deprecatd in 2023
  ([33307](https://github.com/civicrm/civicrm-core/pull/33307))**

- **Remove unused private function
  ([33297](https://github.com/civicrm/civicrm-core/pull/33297))**

- **Remove unused property
  ([33193](https://github.com/civicrm/civicrm-core/pull/33193))**

- **Remove always-true-if
  ([33196](https://github.com/civicrm/civicrm-core/pull/33196))**

- **Remove hard-coded value from previously shared code
  ([33189](https://github.com/civicrm/civicrm-core/pull/33189))**

- **[REF] CustomValue - Use cache not query to fetch custom fields
  ([33317](https://github.com/civicrm/civicrm-core/pull/33317))**

- **[REF] Update loadUser to work for Joomla 4+ and modify calls to jFactory to
  work for 5+ ([32830](https://github.com/civicrm/civicrm-core/pull/32830))**

- **[REF] Refactor text fields in price sets
  ([33040](https://github.com/civicrm/civicrm-core/pull/33040))**

- **[REF] Further cleanup of CRM_Utils_System::theme
  ([33119](https://github.com/civicrm/civicrm-core/pull/33119))**

- **[REF] SearchKit - Code cleanup in ApiBatch tasks
  ([33348](https://github.com/civicrm/civicrm-core/pull/33348))**

- **[NFC] 6.6 release notes
  ([33490](https://github.com/civicrm/civicrm-core/pull/33490))**

- **[NFC] Remove stray js debug statements
  ([33138](https://github.com/civicrm/civicrm-core/pull/33138))**

- **[NFC] Change return type hint in unit test
  ([33211](https://github.com/civicrm/civicrm-core/pull/33211))**

- **[NFC] Settings - Short array syntax
  ([33202](https://github.com/civicrm/civicrm-core/pull/33202))**

- **[NFC] Api4 - Add test for EMPTY and NOT EMPTY operators
  ([33175](https://github.com/civicrm/civicrm-core/pull/33175))**

- **[NFC] add Standalone to README.md
  ([33172](https://github.com/civicrm/civicrm-core/pull/33172))**

- **NFC: Introduce hooks before and after loading settings file
  ([351](https://github.com/civicrm/civicrm-wordpress/pull/351))**

- **[NFC] Follow up to #33351 document reason for inclusion of super permission
  in permissions array
  ([33353](https://github.com/civicrm/civicrm-core/pull/33353))**

- **[NFC] Update Doc Block comment now that function referenced is in a trait
  not on CRM_Core_Resources
  ([33352](https://github.com/civicrm/civicrm-core/pull/33352))**

- **[NFC] Remove method from doc block
  ([33383](https://github.com/civicrm/civicrm-core/pull/33383))**

- **Update tests to avoid deprecated methods
  ([33177](https://github.com/civicrm/civicrm-core/pull/33177))**

- **Update test / Contribution formRule to not rely on UserJob template
  ([33201](https://github.com/civicrm/civicrm-core/pull/33201))**

- **Add unit test for handling other location in the labels, clean up & handle
  group by ([31192](https://github.com/civicrm/civicrm-core/pull/31192))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Artful Robot - Rich Lott; Benjamin W; Brian
Matemachani; BrightMinded Ltd - Bradley Taylor; Christian Wach; Circle
Interactive - Pradeep Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts,
Tim Otten; Coop SymbioTIC - Mathieu Lutfy; Dave D; DevApp - David Cativo; JMA
Consulting - Monish Deb, Seamus Lee; Lemniscus - Noah Miller; Marvin Müller;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Mosier Consulting - Justin Mosier; Nicol Wistreich; Progressive Technology
Project - Jamie McClelland; Richard Baugh; Third Sector Design - Kurund Jalmi,
William Mortada; Wikimedia Foundation - Eileen McNaughton, Wenjun Fan;
Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; All In Appli.com - Guillaume Sorel; Andy Burns;
Australian Greens - Andrew Cormick-Dockery; Civil Justice, Inc. - Brienne K.;
CompuCo - Muhammad Shahrukh; CSES (Chelmsford Science and Engineering Society) -
Adam Wood; Francesc Bassas i Bullich; Fuzion - Luke Stewart; Guydn; JMA
Consulting - Joe Murray; John Kingsnorth; Peter-Reck; New York State Senate -
Nate Harris; Non Profit Tech Advisor - Brian Flett; Squiffle Consulting - Aidan
Saunders; Systopia - Dominic Tubach; Tadpole Collective - Kevin Cristiano;
tapashdatta
